﻿# Remove New Outlook (OneOutlook) and block reinstallation

# Step 1: Remove New Outlook if installed
$package = Get-AppxPackage -Name "Microsoft.OutlookForWindows"

if ($package) {
    Write-Output "New Outlook (OneOutlook) found. Removing..."
    Remove-AppxPackage -Package $package.PackageFullName
} else {
    Write-Output "New Outlook (OneOutlook) is not installed."
}

# Step 2: Block users from reinstalling or switching to New Outlook
$regPath = "HKCU:\Software\Microsoft\Office\16.0\Outlook\Options\General"

# Create registry key if it doesn't exist
if (-not (Test-Path $regPath)) {
    New-Item -Path $regPath -Force | Out-Null
}

# Set registry value to hide the toggle
New-ItemProperty -Path $regPath -Name "HideNewOutlookToggle" -Value 1 -PropertyType "DWord" -Force

Write-Output "New Outlook toggle hidden — users can't reinstall or switch."